#/bin/bash

#环境准备，请查阅http://docs.nwjs.io/en/latest/For%20Users/Package%20and%20Distribute/

SOURCE="${BASH_SOURCE[0]}"
while [ -h "$SOURCE" ]; do # resolve $SOURCE until the file is no longer a symlink
  TARGET="$(readlink "$SOURCE")"
  if [[ $SOURCE == /* ]]; then
    #echo "SOURCE '$SOURCE' is an absolute symlink to '$TARGET'"
    SOURCE="$TARGET"
  else
    DIR="$( dirname "$SOURCE" )"
    #echo "SOURCE '$SOURCE' is a relative symlink to '$TARGET' (relative to '$DIR')"
    if [ $DIR == '.' ]; then 
      SOURCE="$TARGET"
    else
      SOURCE="$DIR/$TARGET" # if $SOURCE was a relative symlink, we need to resolve it relative to the path where the symlink file was located
    fi
  fi
done

#echo "SOURCE is '$SOURCE'"
DIR="$( cd -P "$( dirname "$SOURCE" )" && pwd )"

if [ -z "$WIDEBUILDER" ]; then
  WIDEBUILDER="$(dirname $DIR)/client"
  #echo "WIDEBUILDER=$WIDEBUILDER"
fi

oldpwd=`pwd`

cd $WIDEBUILDER

if [ -d output ];then
  rm -rf output
fi

if [ -d build ];then
  rm -rf build
fi
mkdir build

function showAndExit()
{
  echo -e "\e[34m安装失败：\e[31m"$1
  echo -e "\033[0m"
  exit $2
}

linux64="true"
linux32="true"
win32="true"
win64="true"
#osx64="true"
nwversion="0.14.5-sdk"
withffmpeg="" #--with-ffmpeg
sidebyside="--side-by-side"
mkdir -m 755 output || showAndExit "创建output目录失败：" 1
cp -R $WIDEBUILDER/wide/dep/package.json output/ || showAndExit "拷贝npm的package.json失败" 2
cd output || showAndExit "进入output目录失败" 3
npm install || showAndExit "安装依赖npm包失败" 4
cp -f $WIDEBUILDER/wide/dep/patch/rsyncwrapper.js node_modules/rsyncwrapper/lib/rsyncwrapper.js || showAndExit "无法拷贝rsyncwrapper，这将导致windows下工作异常。" 4
cd ..
cp -f $WIDEBUILDER/wide/package.json output/ || showAndExit "拷贝wide包定义package.json失败" 5
cp -f $WIDEBUILDER/wide/logo.png output/ || showAndExit "拷贝wide图标文件logo.png失败" 6
cp -Rf $WIDEBUILDER/data output/ || showAndExit "拷贝必要的data文件失败" 8
cp -Rf $WIDEBUILDER/chrome-ex output/ || showAndExit "拷贝必要的chrome-ex文件失败" 9

if [[ -n ${linux64} ]];then
  #nwbuild -v 0.14.5 -p linux64 output/ || showAndExit "构建linux64 nwjs发行版失败" 7
  nwb nwbuild -v ${nwversion} -p linux64 ${withffmpeg} ${sidebyside} ./output/ || showAndExit "构建linux64 nwjs发行版失败" 7
  mv wide-linux-x64 build
  cp -Rf $WIDEBUILDER/wide/setup.sh build/wide-linux-x64/ || showAndExit "为linux64拷贝必要的setup.sh文件失败" 10
  cp -f $WIDEBUILDER/wide/wide.desktop build/wide-linux-x64/ || showAndExit "拷贝wide桌面定义文件wide.desktop失败" 11
  chmod +x build/wide-linux-x64/setup.sh
  makeself --nox11 --copy build/wide-linux-x64/ build/wide-linux-x64/wideinstaller.sh "WIDE for linux64" ./setup.sh
fi

if [[ -n ${linux32} ]];then
  #nwbuild -v 0.14.5 -p linux32 output/ || showAndExit "构建linux32 nwjs发行版失败" 8
  nwb nwbuild -v ${nwversion} -p linux32 ${withffmpeg} ${sidebyside} ./output/ || showAndExit "构建linux32 nwjs发行版失败" 7
  mv wide-linux-ia32 build
  cp -Rf $WIDEBUILDER/wide/setup.sh build/wide-linux-ia32/ || showAndExit "为linux32拷贝必要的setup.sh文件失败" 10
  cp -f $WIDEBUILDER/wide/wide.desktop build/wide-linux-ia32/ || showAndExit "拷贝wide桌面定义文件wide.desktop失败" 11
  chmod +x build/wide-linux-ia32/setup.sh
  makeself --nox11 --copy build/wide-linux-ia32/ build/wide-linux-ia32/wideinstaller.sh "WIDE for linux32" ./setup.sh
fi


cp -f $WIDEBUILDER/wide/setup.nsis build
if [[ -n ${win64} ]];then
  nwb nwbuild -v ${nwversion} -p win64 --win-ico wide/logo.ico ${withffmpeg} ${sidebyside} ./output/ || showAndExit "构建win64 nwjs发行版失败" 7
  mv wide-win-x64 build
  mkdir -m 755 -p build/wide-win-x64/tools
  cp -Rf $WIDEBUILDER/tools/win64/* build/wide-win-x64/tools || showAndExit "为win64拷贝必要的tools文件失败" 9
  if [[ -d $WIDEBUILDER/build/src ]];then
    rm $WIDEBUILDER/build/src
  fi
  ln -sf $WIDEBUILDER/build/wide-win-x64 $WIDEBUILDER/build/src
  cp -f $WIDEBUILDER/wide/logo.ico $WIDEBUILDER/build/wide-win-x64
  echo "正在构建安装包，请稍候....."
  makensis $WIDEBUILDER/build/setup.nsis >> $WIDEBUILDER/build/nsislog.txt || showAndExit "构建win64安装程序出错" 9
  mv $WIDEBUILDER/build/setup.exe $WIDEBUILDER/build/setup-x64.exe 
fi

if [[ -n ${win32} ]];then
  nwb nwbuild -v ${nwversion} -p win32 --win-ico wide/logo.ico ${withffmpeg} ${sidebyside} ./output/ || showAndExit "构建win32 nwjs发行版失败" 7
  mv wide-win-ia32 build
  mkdir -m 755 -p build/wide-win-ia32/tools
  cp -Rf $WIDEBUILDER/tools/win32/* build/wide-win-ia32/tools || showAndExit "为win32拷贝必要的tools文件失败" 9
  if [[ -d $WIDEBUILDER/build/src ]];then
    rm $WIDEBUILDER/build/src
  fi
  ln -sf $WIDEBUILDER/build/wide-win-ia32 $WIDEBUILDER/build/src
  echo "正在构建安装包，请稍候....."
  cp -f $WIDEBUILDER/wide/logo.ico $WIDEBUILDER/build/wide-win-ia32
  makensis $WIDEBUILDER/build/setup.nsis >> $WIDEBUILDER/build/nsislog.txt || showAndExit "构建win32安装程序出错" 9
  mv $WIDEBUILDER/build/setup.exe $WIDEBUILDER/build/setup-x86.exe 
fi

#nwbuild -v 0.14.5 -p win32 output/ || showAndExit "构建win32 nwjs发行版失败" 20
#nwbuild -v 0.14.5 -p win64 output/ || showAndExit "构建win64 nwjs发行版失败" 10

#nwjs not provide osx32 release version.
#nwbuild -v 0.14.5 -p osx32 output/ || showAndExit "构建osx32 nwjs发行版失败" 11
#nwbuild -v 0.14.5 -p osx64 output/ || showAndExit "构建osx64 nwjs发行版失败" 12

if [[ -n ${osx64} ]];then
  cp -Rf $WIDEBUILDER/data output/ || showAndExit "为osx拷贝必要的data文件失败" 8
  cp -Rf $WIDEBUILDER/chrome-ex output/ || showAndExit "为osx拷贝必要的chrome-ex文件失败" 9
  nwb nwbuild -v ${nwversion} -p osx64 --mac-icns wide/logo.icns ${withffmpeg} ${sidebyside} ./output/ || showAndExit "构建osx64 nwjs发行版失败" 7
  mv wide-osx-x64 build
fi

cd $oldpwd

echo "构建成功，在${WIDEBUILDER}/build目录下查找对应的发行包文件"
