#!/bin/bash
#这是WIDE安装包.请阅读http://www.wware.org/wide/install.html了解详情。
#WIDE是Wware IDE的简写，属于飞鹿软件研究院(SanPolo.Co.LTD)的注册商标。
#WIDE在WWARE LICENSE下发布。协议全文，请索引http://www.wware.org/LICENSE.txt
#如果对版权有疑义，请联系masol.li@gmail.com
#######################################################################################

function showAndExit()
{
  echo -e "\e[29m安装失败：\e[31m"$1
  echo -e "\033[0m"
  exit $2
}

superUser=`whoami`
user=`who | awk '{print $1}'`

if [[ $superUser != "root" ]];then
  showAndExit "必须使用管理员权限来执行。请使用命令：\n\t\e[33msudo ${BASH_SOURCE[0]} $*" 121
fi

updatedesktopdatabase=`which update-desktop-database`


if [[ -z "$user" ]];then
  echo -e "\e[31mRed"无法获取您的用户名，这将导致无法创建应用快捷方式。
  echo -e "\033[0m"
fi

notfound=`ldd ./wide | grep "not found"`
if [[ ${notfound} ]]; then
  echo "下列依赖库不能满足，请检查您的环境。"
  echo ${notfound}
  exit 1
fi

if [[ $(which yum 2>/dev/null) ]];then
  if [[ ! $(which rsync 2>/dev/null) ]];then
    yum -y install rsync || echo "无法安装rsync。"
  fi
  if [[ ! $(which svn 2>/dev/null) ]];then
    yum -y install subversion || echo "无法安装svn。"
  fi
  if [[ ! $(which git 2>/dev/null) ]];then
    yum -y install git || echo "无法安装svn。"
  fi
  if [[ ! $(which virtualbox 2>/dev/null) ]];then
    yum -y install virtualbox || echo "无法安装virtualbox。"
  fi
elif [[ $(which apt-get 2>/dev/null) ]];then
  if [[ ! $(which rsync 2>/dev/null) ]];then
    apt-get -y install rsync || echo "无法安装rsync。"
  fi
  if [[ ! $(which svn 2>/dev/null) ]];then
    apt-get -y install subversion || echo "无法安装svn。"
  fi
  if [[ ! $(which git 2>/dev/null) ]];then
    apt-get -y install git || echo "无法安装git。"
  fi
  if [[ ! $(which virtualbox 2>/dev/null) ]];then
    apt-get -y install virtualbox || echo "无法安装virtualbox。"
  fi
else
  echo "无法确定您的发行版，无法安装依赖工具，为了确保WIDE功能正常，请手动安装svn,git,rsync以及virtualbox。"
fi

rm -rf /usr/share/wide || showAndExit "无法删除已安装的wide，请确认您有相应权限。" 2
mkdir -m 755 -p /usr/share/wide || showAndExit "无法创建/usr/share/wide目录，请确认您有相应权限。" 3
cp -Rf * /usr/share/wide || showAndExit "无法解压可执行文件到/usr/share/wide目录，请确认您有相应权限。" 4
rm -f /usr/share/wide/setup.sh
find /usr/share/wide/ -type d -exec chmod 755 {} \;
find /usr/share/wide/ -type f -exec chmod a+r {} \;
chmod -R a+r /usr/share/wide
chmod -R a+x /usr/share/wide/wide
chmod -R a+x /usr/share/wide/lib
mkdir -p 777 /usr/share/wide/data/temp
chmod 777 /usr/share/wide/data
chmod 777 /usr/share/wide/data/temp
#ln -fs /usr/share/wide/wide /bin/wide || showAndExit "无法创建wide的快捷链接，请确认您有相应权限。" 5

#create desktop file with logo.png
if [[ -d /usr/share/applications ]];then
 cp -f wide.desktop /usr/share/applications || echo "无法创建桌面定义文件，请手动创建。"
 if [[ -d /home/$user/.local/share/applications ]];then
   cp -f wide.desktop /home/$user/.local/share/applications || echo "无法创建应用快捷方式。"
 fi
elif [[ -d /usr/local/share/applications ]];then
 cp -f wide.desktop /usr/local/share/applications || echo "无法创建桌面定义文件，请手动创建。"
fi

if [[ -n "$updatedesktopdatabase" ]];then
 $updatedesktopdatabase
fi
